-- SQL schema for MySQL / MariaDB
CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(100) NOT NULL UNIQUE,
  email VARCHAR(255),
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('admin','user') DEFAULT 'admin',
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE products (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(255) NOT NULL,
  slug VARCHAR(255) NOT NULL UNIQUE,
  description TEXT,
  price INT NOT NULL DEFAULT 0,
  file_url VARCHAR(1024),
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE orders (
  id INT AUTO_INCREMENT PRIMARY KEY,
  status VARCHAR(50) NOT NULL DEFAULT 'pending',
  total INT NOT NULL DEFAULT 0,
  customer_name VARCHAR(255),
  customer_email VARCHAR(255),
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE order_items (
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL,
  product_id INT NOT NULL,
  qty INT NOT NULL,
  price INT NOT NULL,
  FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE,
  FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE transactions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  order_id INT NOT NULL,
  authority VARCHAR(255),
  gateway VARCHAR(100),
  amount INT NOT NULL,
  status VARCHAR(50) DEFAULT 'initiated',
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  verified_at DATETIME NULL,
  FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE translations (
  id INT AUTO_INCREMENT PRIMARY KEY,
  lang VARCHAR(10) NOT NULL,
  `key` VARCHAR(255) NOT NULL,
  `value` TEXT,
  UNIQUE KEY(lang,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE settings (
  id INT AUTO_INCREMENT PRIMARY KEY,
  `key` VARCHAR(255) NOT NULL UNIQUE,
  `value` TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- sample data
INSERT INTO users (username, email, password_hash, role) VALUES
('admin', 'admin@example.com', '{password_hash}', 'admin');

INSERT INTO products (title, slug, description, price, file_url) VALUES
('Neon Poster — Digital Pack', 'neon-poster', 'High-res neon artwork', 800000, 'https://s6.uupload.ir/files/00_jymd.png'),
('Futuristic Device Mockup','futuristic-mockup','Cinematic lighting mockup',500000,'https://s6.uupload.ir/files/01_e1du.png');

-- replace {password_hash} with a hashed password (see README)
