<?php
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/includes/db.php';
$lang = detect_lang();
$dir = in_array($lang, ['fa']) ? 'rtl' : 'ltr';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$pdo = getPDO();
$stmt = $pdo->prepare('SELECT * FROM products WHERE id = ? LIMIT 1');
$stmt->execute([$id]);
$product = $stmt->fetch();
if (!$product) {
    http_response_code(404);
    echo '<h1>Product not found</h1>'; exit;
}
?>
<!doctype html>
<html lang="<?php echo e($lang);?>" dir="<?php echo e($dir);?>">
<head><meta charset="utf-8"><title><?php echo e($product['title']);?></title></head>
<body>
<h1><?php echo e($product['title']);?></h1>
<p><?php echo e($product['description']);?></p>
<p>Price: <?php echo e(number_format($product['price']));?></p>
<form method="post" action="/api/cart_add.php">
<input type="hidden" name="product_id" value="<?php echo e($product['id']);?>">
<input type="hidden" name="csrf" value="<?php echo e(csrf_token());?>">
<button type="submit">Add to cart</button>
</form>
</body>
</html>
