<?php
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/includes/db.php';
$pdo = getPDO();
// Zarinpal will send GET params: Authority and Status=OK or something similar
$authority = $_GET['Authority'] ?? '';
$status = $_GET['Status'] ?? '';
// find transaction
$stmt = $pdo->prepare('SELECT * FROM transactions WHERE authority = ? LIMIT 1');
$stmt->execute([$authority]);
$tx = $stmt->fetch();
if (!$tx) {
    http_response_code(400);
    echo 'Transaction not found';
    exit;
}
if (strtoupper($status) !== 'OK') {
    // failed or cancelled
    $pdo->prepare('UPDATE transactions SET status = ?, verified_at = NOW() WHERE id = ?')->execute(['failed', $tx['id']]);
    $pdo->prepare('UPDATE orders SET status = ? WHERE id = ?')->execute(['cancelled', $tx['order_id']]);
    echo 'Payment failed or cancelled';
    exit;
}
// In real integration call Verify API to verify authority and amount
// For demo: mark as paid
$pdo->prepare('UPDATE transactions SET status = ?, verified_at = NOW() WHERE id = ?')->execute(['paid', $tx['id']]);
$pdo->prepare('UPDATE orders SET status = ? WHERE id = ?')->execute(['paid', $tx['order_id']]);

// clear cart
session_start(); unset($_SESSION['cart']);
echo 'Payment successful. Thank you.';
