<?php
// public/index.php - renders the uploaded HTML unmodified (CSS intact).
require_once __DIR__ . '/includes/functions.php';
$lang = detect_lang();
$dir = in_array($lang, ['fa']) ? 'rtl' : 'ltr';
$translations = load_translations($lang);
// read original template (kept exactly as user provided)
$tpl = file_get_contents(__DIR__ . '/index.html');
// replace the opening <html ...> with dynamic lang/dir
$tpl = preg_replace('/<html[^>]*>/', '<html lang="' . e($lang) . '" dir="' . e($dir) . '">', $tpl, 1);
// inject a small JSON blob for server-side translations used by PHP-rendered snippets if needed
$inject = "\n<script>window.__SERVER_I18N = " . json_encode($translations, JSON_UNESCAPED_UNICODE) . ";</script>\n";
$tpl = str_replace('</head>', "</head>" . $inject, $tpl);
echo $tpl;
