<?php
// Common helper functions
session_start();

function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); }

// CSRF
function csrf_token(){
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(24));
    }
    return $_SESSION['csrf_token'];
}
function verify_csrf($token){
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Language detection: URL prefix (/en/ or /fa/) or cookie or Accept-Language
function detect_lang(){
    // Check URL path prefix
    $uri = $_SERVER['REQUEST_URI'] ?? '/';
    $parts = explode('/', trim($uri,'/'));
    $first = $parts[0] ?? '';
    $supported = ['en','fa'];
    if (in_array($first, $supported)) {
        setcookie('lang', $first, time()+3600*24*30, '/');
        return $first;
    }
    if (!empty($_COOKIE['lang'])) return $_COOKIE['lang'];
    $al = $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? 'en';
    $lang = substr($al,0,2);
    return in_array($lang,$supported) ? $lang : 'en';
}

function load_translations($lang='en'){
    static $cache = [];
    if (isset($cache[$lang])) return $cache[$lang];
    $path = __DIR__ . "/../../lang/{$lang}.json";
    if (!file_exists($path)) {
        $path = __DIR__ . "/../../lang/en.json";
    }
    $json = file_get_contents($path);
    $cache[$lang] = json_decode($json, true);
    return $cache[$lang];
}

function t($key, $lang=null){
    $lang = $lang ?? detect_lang();
    $map = load_translations($lang);
    return $map[$key] ?? ($map['__fallback'] ?? $key);
}

// Cart (session-based)
function cart_add($product_id, $qty=1){
    $pid = (int)$product_id;
    $qty = max(1, (int)$qty);
    if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];
    if (!isset($_SESSION['cart'][$pid])) $_SESSION['cart'][$pid] = 0;
    $_SESSION['cart'][$pid] += $qty;
    return true;
}
function cart_remove($product_id){
    $pid = (int)$product_id;
    if (isset($_SESSION['cart'][$pid])) {
        unset($_SESSION['cart'][$pid]);
        return true;
    }
    return false;
}
function cart_items(){
    return $_SESSION['cart'] ?? [];
}
function cart_count(){
    $c = array_sum(array_values(cart_items()));
    return $c;
}
