<?php
require_once __DIR__.'/env.php';
function getPDO() {
    static $pdo = null;
    if ($pdo) return $pdo;
    $host = env('DB_HOST','127.0.0.1');
    $db   = env('DB_NAME','shop_db');
    $user = env('DB_USER','root');
    $pass = env('DB_PASS','');
    $dsn = "mysql:host={$host};dbname={$db};charset=utf8mb4";
    $opt = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    $pdo = new PDO($dsn, $user, $pass, $opt);
    return $pdo;
}
