<?php
require_once __DIR__.'/db.php';
function admin_check(){
    session_start();
    return (!empty($_SESSION['admin']) && $_SESSION['admin']===true);
}
function admin_login($username, $password){
    $pdo = getPDO();
    $stmt = $pdo->prepare('SELECT id, username, password_hash FROM users WHERE username = ? AND role = "admin" LIMIT 1');
    $stmt->execute([$username]);
    $row = $stmt->fetch();
    if ($row && password_verify($password, $row['password_hash'])) {
        $_SESSION['admin'] = true;
        $_SESSION['admin_id'] = $row['id'];
        $_SESSION['admin_username'] = $row['username'];
        return true;
    }
    return false;
}
function admin_logout(){
    session_start();
    session_unset();
    session_destroy();
}
