<?php
require_once __DIR__.'/src/includes/functions.php';
require_once __DIR__.'/src/includes/db.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    // allow GET to show checkout
    header('Location: /cart.php'); exit;
}
$token = $_POST['csrf'] ?? '';
if (!verify_csrf($token)) { die('Invalid CSRF'); }
$items = cart_items();
if (empty($items)) { die('Cart empty'); }
$pdo = getPDO();
// compute total
$ids = array_keys($items);
$placeholders = implode(',', array_fill(0, count($ids), '?'));
$stmt = $pdo->prepare("SELECT id, price FROM products WHERE id IN ({$placeholders})");
$stmt->execute($ids);
$rows = $stmt->fetchAll();
$total = 0;
foreach ($rows as $r) {
    $qty = $items[$r['id']];
    $total += $r['price'] * $qty;
}
// create order
$pdo->beginTransaction();
$stmt = $pdo->prepare('INSERT INTO orders (status, total, created_at) VALUES (?, ?, NOW())');
$stmt->execute(['pending', $total]);
$order_id = $pdo->lastInsertId();
// insert order items
$ins = $pdo->prepare('INSERT INTO order_items (order_id, product_id, qty, price) VALUES (?, ?, ?, ?)');
foreach ($rows as $r) {
    $qty = $items[$r['id']];
    $ins->execute([$order_id, $r['id'], $qty, $r['price']]);
}
// create transaction record with status 'initiated'
$stmt = $pdo->prepare('INSERT INTO transactions (order_id, amount, status, created_at) VALUES (?, ?, ?, NOW())');
$stmt->execute([$order_id, $total, 'initiated']);
$transaction_id = $pdo->lastInsertId();
$pdo->commit();

// Redirect to Zarinpal (placeholder implementation)
// In production, use ZARINPAL_MERCHANT_ID from env and call PaymentRequest API (POST) for Authority
$merchant = env('ZARINPAL_MERCHANT_ID','xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx');
$base = rtrim(env('BASE_URL','http://example.com'), '/');
$callback = $base . '/payment/callback.php';
$description = 'Order #' . $order_id;
$amount = (int)$total; // Zarinpal expects amount in Toman or Rial depending on integration — set properly in .env and docs
// We'll store a placeholder authority and redirect to sandbox page for testing
$authority = bin2hex(random_bytes(8));
$pdo = getPDO();
$pdo->prepare('UPDATE transactions SET authority = ?, gateway = ?, status = ? WHERE id = ?')
    ->execute([$authority, 'zarinpal_sandbox', 'redirected', $transaction_id]);

// redirect
$zarinpal_url = 'https://sandbox.zarinpal.com/pg/StartPay/' . $authority;
header('Location: ' . $zarinpal_url);
exit;
