<?php
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/includes/db.php';
$lang = detect_lang();
$dir = in_array($lang, ['fa']) ? 'rtl' : 'ltr';
$items = cart_items();
$pdo = getPDO();
$products = [];
$total = 0;
if ($items) {
    $ids = array_map('intval', array_keys($items));
    $in = implode(',', array_fill(0, count($ids), '?'));
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id IN ({$in})");
    $stmt->execute($ids);
    $rows = $stmt->fetchAll();
    foreach ($rows as $r) {
        $r['qty'] = $items[$r['id']] ?? 0;
        $r['subtotal'] = $r['qty'] * $r['price'];
        $total += $r['subtotal'];
        $products[] = $r;
    }
}
?>
<!doctype html><html lang="<?php echo e($lang);?>" dir="<?php echo e($dir);?>"><head><meta charset="utf-8"><title>Cart</title></head><body>
<h1>Cart (<?php echo cart_count();?>)</h1>
<?php if(!$products): ?>
<p>Cart is empty</p>
<?php else: ?>
<ul>
<?php foreach($products as $p): ?>
<li><?php echo e($p['title']);?> x <?php echo e($p['qty']);?> = <?php echo number_format($p['subtotal']);?></li>
<?php endforeach; ?>
</ul>
<p>Total: <?php echo number_format($total);?></p>
<form method="post" action="/checkout.php">
<input type="hidden" name="csrf" value="<?php echo e(csrf_token());?>">
<button type="submit">Checkout</button>
</form>
<?php endif; ?>
</body></html>
