<?php
require_once __DIR__.'/../../src/includes/functions.php';
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); echo json_encode(['error'=>'Method']); exit;
}
$data = json_decode(file_get_contents('php://input'), true);
$token = $data['csrf'] ?? '';
if (!verify_csrf($token)) { http_response_code(403); echo json_encode(['error'=>'Invalid CSRF']); exit; }
$id = isset($data['product_id']) ? (int)$data['product_id'] : 0;
if ($id<=0) { http_response_code(400); echo json_encode(['error'=>'Invalid']); exit; }
cart_remove($id);
echo json_encode(['ok'=>true,'count'=>cart_count()]);
