<?php
require_once __DIR__.'/../../src/includes/functions.php';
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); echo json_encode(['error'=>'Method']); exit;
}
$token = $_POST['csrf'] ?? '';
if (!verify_csrf($token)) { http_response_code(403); echo json_encode(['error'=>'Invalid CSRF']); exit; }
$product_id = isset($_POST['product_id']) ? (int)$_POST['product_id'] : 0;
$qty = isset($_POST['qty']) ? (int)$_POST['qty'] : 1;
if ($product_id <= 0) { http_response_code(400); echo json_encode(['error'=>'Invalid product']); exit; }
cart_add($product_id, $qty);
echo json_encode(['ok'=>true,'count'=>cart_count()]);
