# Ready-to-deploy PHP + MySQL storefront (uses user's HTML/CSS template)

## What's included
- The original HTML/CSS provided by the user (kept unchanged). Referenced at root `index.html.txt`. fileciteturn0file0
- PHP back-end using PDO, prepared statements and basic security.
- Session-based cart.
- Zarinpal payment flow (sandbox placeholders).
- i18n via `lang/en.json` and `lang/fa.json`.
- Admin area (simple password login).
- SQL schema: `schema.sql`.

## Quick install (Linux hosting)
1. Upload the entire `website` folder content to your server's document root (e.g. `/var/www/html`).
   - Ensure `public/` is the web-accessible folder. Point your vhost root to `/path/to/website/public`.
2. Copy `.env.example` to `.env` at repository root and fill DB and Zarinpal values.
3. Create the MySQL database and run `schema.sql`. Update the admin password hash (see note below).
4. Ensure PHP 8.x and required extensions (pdo_mysql) are installed.
5. Set file permissions for `storage` if you add uploads later.
6. Configure Zarinpal callback URL in Zarinpal dashboard to: `https://your-domain.com/payment/callback.php`
   - For sandbox/testing use sandbox merchant ID and sandbox endpoint.
7. Enable HTTPS (Let's Encrypt) before moving to production.

## Password hash
The `schema.sql` includes `{password_hash}` token. Generate a password hash (PHP CLI):
```php
<?php
echo password_hash('your-admin-password', PASSWORD_DEFAULT);
```
Paste the result into `schema.sql` before running, or manually insert admin user after running SQL.

## Zarinpal integration notes
- Fill `ZARINPAL_MERCHANT_ID` in `.env`.
- Zarinpal expects amounts in Iranian Rial or Toman depending on config — ensure correct unit.
- The included flow uses sandbox redirect for demo. Replace with real PaymentRequest and PaymentVerification calls (see Zarinpal docs) and handle error codes.

## Files
- `index.html.txt` — original full HTML + CSS (DO NOT EDIT CSS).
- `public/` — PHP endpoints and web-accessible files.
- `src/includes/` — helper libraries (db, functions, auth).
- `lang/` — translation JSON files.
- `schema.sql` — DB schema and sample data.

## Testing Zarinpal (sandbox)
1. Use sandbox merchant id in `.env`.
2. Ensure callback URL is reachable from Zarinpal.
3. Perform checkout and you will be redirected to the sandbox payment page. The `callback.php` will simulate verification for sandbox.

## Security considerations
- All DB access uses PDO + prepared statements.
- CSRF tokens implemented for forms.
- Escape outputs with `htmlspecialchars`.
- Limit file uploads (if added) via `php.ini` and server rules.
- Use HTTPS and set secure cookies in production.

## Notes
- The original CSS block was preserved exactly and is embedded in `index.html.txt`. Do not change it.
